-- Create testimonials table for storing user messages
CREATE TABLE public.testimonials (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  name TEXT NOT NULL,
  message TEXT NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

-- Enable Row Level Security
ALTER TABLE public.testimonials ENABLE ROW LEVEL SECURITY;

-- Allow anyone to insert testimonials (no auth required)
CREATE POLICY "Anyone can insert testimonials" 
ON public.testimonials 
FOR INSERT 
WITH CHECK (true);

-- Allow anyone to read testimonials
CREATE POLICY "Anyone can read testimonials" 
ON public.testimonials 
FOR SELECT 
USING (true);