-- Create admin settings table
CREATE TABLE IF NOT EXISTS public.site_settings (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  key TEXT UNIQUE NOT NULL,
  value TEXT,
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT now()
);

-- Enable RLS
ALTER TABLE public.site_settings ENABLE ROW LEVEL SECURITY;

-- Allow public read access
CREATE POLICY "Allow public read access" ON public.site_settings FOR SELECT USING (true);

-- Allow authenticated users to update
CREATE POLICY "Allow authenticated users to update" ON public.site_settings FOR UPDATE USING (auth.role() = 'authenticated');

-- Insert default settings
INSERT INTO public.site_settings (key, value) VALUES
  ('current_show', 'Programação Gospel'),
  ('current_host', 'Equipe Mega Gospel'),
  ('site_phone', '(19) 99195-2357'),
  ('site_email', 'contato@radiomegagospel.com.br'),
  ('whatsapp_number', '5519991952357')
ON CONFLICT (key) DO NOTHING;
