import { useState } from "react";
import { Card } from "@/components/ui/card";
import { Quote, Star } from "lucide-react";
import TestimonialChat from "@/components/TestimonialChat";

const TestimonialsSection = () => {
  const [isChatOpen, setIsChatOpen] = useState(false);

  const testimonials = [
    {
      name: "Maria Silva",
      location: "São Paulo, SP",
      text: "A Rádio Mega Gospel mudou minha vida! Todos os dias acordo ao som dos louvores e mensagens que fortalecem minha fé. É como ter uma igreja em casa 24 horas por dia.",
      rating: 5,
      role: "Ouvinte há 5 anos",
    },
    {
      name: "João Santos",
      location: "Campinas, SP",
      text: "Encontrei na Mega Gospel um refúgio nos momentos difíceis. As mensagens e músicas me ajudaram a superar desafios e a me aproximar mais de Deus. Gratidão eterna!",
      rating: 5,
      role: "Ouvinte há 3 anos",
    },
    {
      name: "Ana Oliveira",
      location: "Rio de Janeiro, RJ",
      text: "Impossível não se emocionar com a qualidade dos programas e a seleção musical. A Rádio Mega Gospel é parte da minha rotina diária e da minha família.",
      rating: 5,
      role: "Ouvinte há 7 anos",
    },
  ];

  return (
    <section id="depoimentos" className="py-20 bg-gradient-to-b from-muted to-background">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          {/* Section Header */}
          <div className="text-center mb-16 space-y-4">
            <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] bg-clip-text text-transparent">
              O Que Dizem Nossos Ouvintes
            </h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Testemunhos reais de pessoas que tiveram suas vidas transformadas
            </p>
          </div>

          {/* Testimonials Grid */}
          <div className="grid md:grid-cols-3 gap-8">
            {testimonials.map((testimonial, index) => (
              <Card
                key={index}
                className="p-8 relative hover:shadow-[var(--shadow-elegant)] transition-all duration-300 hover:-translate-y-2"
              >
                {/* Quote Icon */}
                <div className="absolute top-6 right-6 w-12 h-12 rounded-full bg-primary/10 flex items-center justify-center">
                  <Quote className="w-6 h-6 text-primary" />
                </div>

                {/* Content */}
                <div className="space-y-4">
                  {/* Stars */}
                  <div className="flex gap-1">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-5 h-5 fill-secondary text-secondary" />
                    ))}
                  </div>

                  {/* Testimonial Text */}
                  <p className="text-muted-foreground leading-relaxed italic">"{testimonial.text}"</p>

                  {/* Author Info */}
                  <div className="pt-4 border-t border-border">
                    <p className="font-bold text-foreground">{testimonial.name}</p>
                    <p className="text-sm text-muted-foreground">{testimonial.role}</p>
                    <p className="text-xs text-muted-foreground mt-1">{testimonial.location}</p>
                  </div>
                </div>
              </Card>
            ))}
          </div>

          {/* Call to Action */}
          <div className="mt-12 text-center">
            <Card className="p-8 bg-gradient-to-r from-primary/5 to-[hsl(var(--primary-variant))]/5 border-primary/20">
              <h3 className="text-2xl font-bold text-foreground mb-3">Quer Compartilhar Seu Testemunho?</h3>
              <p className="text-muted-foreground mb-6">
                Sua história pode inspirar e abençoar milhares de pessoas
              </p>
              <button
                onClick={() => setIsChatOpen(true)}
                className="inline-flex items-center gap-2 px-6 py-3 bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] text-primary-foreground rounded-lg font-semibold hover:shadow-[var(--shadow-glow)] hover:scale-105 transition-all duration-300"
              >
                Enviar Testemunho
              </button>
            </Card>
          </div>

          {/* Testimonial Chat Modal */}
          {isChatOpen && <TestimonialChat onClose={() => setIsChatOpen(false)} />}
        </div>
      </div>
    </section>
  );
};

export default TestimonialsSection;
