import { Music, Mic, Clock, Users } from "lucide-react";
import { Card } from "@/components/ui/card";

const ServicesSection = () => {
  const services = [
    {
      icon: Music,
      title: "Música Gospel 24h",
      description:
        "As melhores músicas gospel nacionais e internacionais tocando sem parar para alegrar seu dia e fortalecer sua fé.",
      color: "from-primary to-[hsl(var(--primary-variant))]",
    },
    {
      icon: Mic,
      title: "Programas Especiais",
      description:
        "Programas temáticos com mensagens inspiradoras, testemunhos emocionantes e estudos bíblicos profundos.",
      color: "from-accent to-secondary",
    },
    {
      icon: Clock,
      title: "Transmissão Ao Vivo",
      description:
        "Cultos ao vivo, eventos especiais e shows gospel transmitidos diretamente para você onde quer que esteja.",
      color: "from-secondary to-accent",
    },
    {
      icon: Users,
      title: "Interação com Ouvintes",
      description:
        "Participe através do WhatsApp enviando pedidos de oração, músicas e compartilhando seu testemunho conosco.",
      color: "from-[hsl(var(--primary-variant))] to-primary",
    },
  ];

  const schedule = [
    { time: "06:00", program: "Louvor Matinal", host: "Pastor João" },
    { time: "09:00", program: "Palavra Viva", host: "Pastora Maria" },
    { time: "12:00", program: "Almoço Gospel", host: "DJ Carlos" },
    { time: "15:00", program: "Tarde de Louvor", host: "Ana Paula" },
    { time: "18:00", program: "Louvor da Noite", host: "Pastor Pedro" },
    { time: "21:00", program: "Adoração Noturna", host: "Ministério Alfa" },
  ];

  return (
    <section id="programacao" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          {/* Section Header */}
          <div className="text-center mb-16 space-y-4">
            <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] bg-clip-text text-transparent">
              Nossa Programação
            </h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Conteúdo de qualidade para edificar sua vida espiritual
            </p>
          </div>

          {/* Services Grid */}
          <div className="grid md:grid-cols-2 gap-6 mb-16">
            {services.map((service, index) => (
              <Card
                key={index}
                className="p-8 hover:shadow-[var(--shadow-elegant)] transition-all duration-300 hover:-translate-y-1 group"
              >
                <div
                  className={`w-16 h-16 rounded-xl bg-gradient-to-br ${service.color} flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}
                >
                  <service.icon className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-2xl font-bold text-foreground mb-3">{service.title}</h3>
                <p className="text-muted-foreground leading-relaxed">{service.description}</p>
              </Card>
            ))}
          </div>

          {/* Schedule Table */}
          <div className="mt-16">
            <h3 className="text-3xl font-bold text-center text-foreground mb-8">Grade de Programação</h3>
            <Card className="overflow-hidden">
              <div className="overflow-x-auto">
                <table className="w-full">
                  <thead className="bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] text-primary-foreground">
                    <tr>
                      <th className="px-6 py-4 text-left font-semibold">Horário</th>
                      <th className="px-6 py-4 text-left font-semibold">Programa</th>
                      <th className="px-6 py-4 text-left font-semibold">Apresentador</th>
                    </tr>
                  </thead>
                  <tbody className="divide-y divide-border">
                    {schedule.map((item, index) => (
                      <tr key={index} className="hover:bg-accent/5 transition-colors">
                        <td className="px-6 py-4 font-bold text-primary">{item.time}</td>
                        <td className="px-6 py-4 font-semibold text-foreground">{item.program}</td>
                        <td className="px-6 py-4 text-muted-foreground">{item.host}</td>
                      </tr>
                    ))}
                  </tbody>
                </table>
              </div>
            </Card>
            <p className="text-center text-sm text-muted-foreground mt-4">
              * Programação sujeita a alterações. Acompanhe nossas redes sociais para atualizações.
            </p>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ServicesSection;
