import { Button } from "@/components/ui/button";
import { Radio, Play } from "lucide-react";
import heroBg from "@/assets/hero-bg.jpg";

const HeroSection = () => {
  return (
    <section
      id="inicio"
      className="relative min-h-screen flex items-center justify-center pt-20 overflow-hidden"
      style={{
        backgroundImage: `linear-gradient(135deg, rgba(83, 45, 126, 0.95) 0%, rgba(75, 85, 185, 0.9) 50%, rgba(83, 45, 126, 0.95) 100%), url(${heroBg})`,
        backgroundSize: "cover",
        backgroundPosition: "center",
        backgroundAttachment: "fixed",
      }}
    >
      {/* Animated overlay */}
      <div className="absolute inset-0 bg-gradient-to-b from-transparent via-primary/20 to-background/80"></div>

      {/* Sound waves animation */}
      <div className="absolute inset-0 overflow-hidden opacity-20">
        <div className="absolute inset-0 flex items-center justify-center">
          {[...Array(5)].map((_, i) => (
            <div
              key={i}
              className="absolute w-[200%] h-[200%] rounded-full border-2 border-secondary animate-ping"
              style={{
                animationDelay: `${i * 0.5}s`,
                animationDuration: "4s",
              }}
            ></div>
          ))}
        </div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div className="max-w-4xl mx-auto text-center space-y-8">
          {/* Badge */}
          <div className="inline-flex items-center gap-2 px-6 py-3 rounded-full bg-white/10 backdrop-blur-sm border border-white/20 text-white animate-in fade-in slide-in-from-top-4 duration-700">
            <div className="w-2 h-2 rounded-full bg-accent animate-pulse"></div>
            <span className="text-sm font-medium">Transmitindo 24h por dia</span>
          </div>

          {/* Main Heading */}
          <h1 className="text-5xl md:text-7xl font-bold text-white leading-tight animate-in fade-in slide-in-from-bottom-4 duration-700 delay-100">
            Transforme sua vida através da
            <span className="block bg-gradient-to-r from-secondary to-accent bg-clip-text text-transparent mt-2">
              música gospel
            </span>
          </h1>

          {/* Subtitle */}
          <p className="text-xl md:text-2xl text-white/90 max-w-2xl mx-auto animate-in fade-in slide-in-from-bottom-4 duration-700 delay-200">
            A Rádio Mega Gospel é sua fonte de inspiração, fé e esperança 24 horas por dia
          </p>

          {/* CTAs */}
          <div className="flex flex-col sm:flex-row items-center justify-center gap-4 pt-4 animate-in fade-in slide-in-from-bottom-4 duration-700 delay-300">
            <Button variant="golden" size="xl" asChild>
              <a href="https://wa.me/5519991952357" target="_blank" rel="noopener noreferrer">
                <Radio className="w-5 h-5" />
                Fale no WhatsApp
              </a>
            </Button>
            <Button variant="outline" size="xl" className="bg-white/10 backdrop-blur-sm border-white/30 text-white hover:bg-white hover:text-primary">
              <Play className="w-5 h-5" />
              Ouça Agora
            </Button>
          </div>

          {/* Contact Info */}
          <div className="pt-8 text-white text-lg font-semibold animate-in fade-in duration-700 delay-500 drop-shadow-[0_2px_4px_rgba(0,0,0,0.8)]">
            <p>📞 Fone: (19) 99195-2357</p>
          </div>
        </div>
      </div>

      {/* Bottom gradient */}
      <div className="absolute bottom-0 left-0 right-0 h-32 bg-gradient-to-t from-background to-transparent"></div>
    </section>
  );
};

export default HeroSection;
