import { useState } from "react";
import { Card } from "@/components/ui/card";
import { Dialog, DialogContent } from "@/components/ui/dialog";

const GallerySection = () => {
  const [selectedImage, setSelectedImage] = useState<number | null>(null);

  // Placeholder images - In production, these would come from backend
  const galleryItems = [
    {
      title: "Culto Especial de Louvor",
      description: "Grande encontro com ministérios convidados",
      image: "https://images.unsplash.com/photo-1511671782779-c97d3d27a1d4?w=800",
    },
    {
      title: "Estúdio da Mega Gospel",
      description: "Nossa estrutura profissional de transmissão",
      image: "https://images.unsplash.com/photo-1598488035139-bdbb2231ce04?w=800",
    },
    {
      title: "Evento Solidário",
      description: "Arrecadação de alimentos para comunidade",
      image: "https://images.unsplash.com/photo-1491438590914-bc09fcaaf77a?w=800",
    },
    {
      title: "Show Gospel ao Vivo",
      description: "Transmissão especial com artistas renomados",
      image: "https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=800",
    },
    {
      title: "Conferência Anual",
      description: "Encontro de rádios gospel do Brasil",
      image: "https://images.unsplash.com/photo-1501281668745-f7f57925c3b4?w=800",
    },
    {
      title: "Equipe Mega Gospel",
      description: "Nosso time dedicado de profissionais",
      image: "https://images.unsplash.com/photo-1516450360452-9312f5e86fc7?w=800",
    },
  ];

  return (
    <section id="galeria" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          {/* Section Header */}
          <div className="text-center mb-16 space-y-4">
            <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] bg-clip-text text-transparent">
              Nossa Galeria
            </h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Momentos especiais e eventos marcantes da Rádio Mega Gospel
            </p>
          </div>

          {/* Gallery Grid */}
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {galleryItems.map((item, index) => (
              <Card
                key={index}
                className="group cursor-pointer overflow-hidden hover:shadow-[var(--shadow-elegant)] transition-all duration-300"
                onClick={() => setSelectedImage(index)}
              >
                <div className="relative aspect-square overflow-hidden">
                  <img
                    src={item.image}
                    alt={item.title}
                    className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                    <div className="absolute bottom-0 left-0 right-0 p-6 text-white">
                      <h3 className="text-xl font-bold mb-2">{item.title}</h3>
                      <p className="text-sm text-white/90">{item.description}</p>
                    </div>
                  </div>
                </div>
              </Card>
            ))}
          </div>

          {/* Lightbox Dialog */}
          <Dialog open={selectedImage !== null} onOpenChange={() => setSelectedImage(null)}>
            <DialogContent className="max-w-4xl p-0 bg-transparent border-none">
              {selectedImage !== null && (
                <div className="relative">
                  <img
                    src={galleryItems[selectedImage].image}
                    alt={galleryItems[selectedImage].title}
                    className="w-full h-auto rounded-lg"
                  />
                  <div className="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/90 to-transparent p-6 text-white rounded-b-lg">
                    <h3 className="text-2xl font-bold mb-2">{galleryItems[selectedImage].title}</h3>
                    <p className="text-white/90">{galleryItems[selectedImage].description}</p>
                  </div>
                </div>
              )}
            </DialogContent>
          </Dialog>
        </div>
      </div>
    </section>
  );
};

export default GallerySection;
