import { Heart, Users, Radio, Award } from "lucide-react";
import { Card } from "@/components/ui/card";

const AboutSection = () => {
  const stats = [
    { icon: Radio, label: "Anos no Ar", value: "10+" },
    { icon: Users, label: "Ouvintes", value: "50k+" },
    { icon: Heart, label: "Vidas Tocadas", value: "100k+" },
    { icon: Award, label: "Prêmios", value: "15+" },
  ];

  return (
    <section id="sobre" className="py-20 bg-gradient-to-b from-background to-muted">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          {/* Section Header */}
          <div className="text-center mb-16 space-y-4">
            <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-primary to-[hsl(var(--primary-variant))] bg-clip-text text-transparent">
              Sobre a Rádio Mega Gospel
            </h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Uma história de fé, dedicação e amor pela palavra de Deus
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-12 items-center mb-16">
            {/* Image/Visual */}
            <div className="relative">
              <div className="aspect-square rounded-2xl bg-gradient-to-br from-primary to-[hsl(var(--primary-variant))] p-1 shadow-[var(--shadow-elegant)]">
                <div className="w-full h-full rounded-xl bg-background flex items-center justify-center">
                  <div className="text-center space-y-4 p-8">
                    <Radio className="w-24 h-24 mx-auto text-primary" />
                    <h3 className="text-2xl font-bold text-primary">Rádio Mega Gospel</h3>
                    <p className="text-muted-foreground">A voz que transforma</p>
                  </div>
                </div>
              </div>
              <div className="absolute -top-6 -right-6 w-32 h-32 bg-secondary/20 rounded-full blur-3xl"></div>
              <div className="absolute -bottom-6 -left-6 w-32 h-32 bg-accent/20 rounded-full blur-3xl"></div>
            </div>

            {/* Content */}
            <div className="space-y-6">
              <h3 className="text-3xl font-bold text-foreground">Nossa História</h3>
              <p className="text-muted-foreground leading-relaxed">
                Desde nossa fundação, a Rádio Mega Gospel tem sido um farol de esperança e fé para milhares de
                pessoas. Nascemos com a missão de levar a palavra de Deus através da música gospel e mensagens
                inspiradoras que transformam vidas.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Ao longo dos anos, crescemos e evoluímos, mas nossa essência permanece a mesma: ser um canal de
                bênçãos, conectando pessoas a Deus através da música e da palavra.
              </p>

              <div className="space-y-4 pt-4">
                <div className="flex items-start gap-3">
                  <div className="w-8 h-8 rounded-full bg-primary/10 flex items-center justify-center flex-shrink-0">
                    <Heart className="w-4 h-4 text-primary" />
                  </div>
                  <div>
                    <h4 className="font-semibold text-foreground mb-1">Missão</h4>
                    <p className="text-sm text-muted-foreground">
                      Levar a palavra de Deus através da música gospel de qualidade e mensagens que transformam vidas
                    </p>
                  </div>
                </div>

                <div className="flex items-start gap-3">
                  <div className="w-8 h-8 rounded-full bg-accent/10 flex items-center justify-center flex-shrink-0">
                    <Award className="w-4 h-4 text-accent" />
                  </div>
                  <div>
                    <h4 className="font-semibold text-foreground mb-1">Visão</h4>
                    <p className="text-sm text-muted-foreground">
                      Ser referência em comunicação gospel, alcançando corações e transformando o Brasil através da fé
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
            {stats.map((stat, index) => (
              <Card
                key={index}
                className="p-6 text-center space-y-3 hover:shadow-[var(--shadow-card)] transition-shadow duration-300"
              >
                <div className="w-12 h-12 mx-auto rounded-full bg-gradient-to-br from-primary to-[hsl(var(--primary-variant))] flex items-center justify-center">
                  <stat.icon className="w-6 h-6 text-primary-foreground" />
                </div>
                <div className="text-3xl font-bold text-primary">{stat.value}</div>
                <div className="text-sm text-muted-foreground">{stat.label}</div>
              </Card>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutSection;
